# Declaration
To prevent code misuse, we only provide baseline code and our prompts, including:
- OFA method and prompts in the MobileNet search space,
- Random search, evolutionary algorithms, reinforcement learning and prompts on NAS-Bench-201.

If the paper is accepted, we will open-source full implementations across all supported search spaces.


# Note
The code contains attribution headers from original OFA and NATS-Bench implementations as required by their licenses. These citations do not compromise anonymity as they are not connected to the authors of this work.
```python
# Once for All: Train One Network and Specialize it for Efficient Deployment
# Han Cai, Chuang Gan, Tianzhe Wang, Zhekai Zhang, Song Han
# International Conference on Learning Representations (ICLR), 2020.
```


# Running Search Algorithms

## Prerequisites
```bash
pip install -r requirements.txt
```

## MobileNet Search Space
Run OFA search algorithm:
```bash
cd MobileNet
python search_OFA.py
```

## NAS-Bench-201 Search Space
Run different search algorithms:
```bash
cd NAS-Bench-201

# Evolutionary Algorithm
python search_EA.py

# Random Search
python search_Random.py

# Reinforcement Learning
python search_Reinforce.py
```